namespace LLM.HHData.Services;

public sealed class WorkTracker
{
    private int _inFlight;
    private volatile bool _seedingCompleted;
    private readonly EmployersChannelHolder _holder;

    public WorkTracker(EmployersChannelHolder holder) => _holder = holder;

    // вызывать перед каждой постановкой employerId в канал
    public void Increment() => Interlocked.Increment(ref _inFlight);

    // вызывать один раз, когда закончилась первичная закидка из sitemap
    public void MarkSeedingCompleted()
    {
        _seedingCompleted = true;
        TryCompleteIfIdle();
    }

    // вызывать после обработки каждого employerId агентом
    public void DecrementAndMaybeComplete()
    {
        var left = Interlocked.Decrement(ref _inFlight);
        if (left < 0) Interlocked.Exchange(ref _inFlight, 0);
        TryCompleteIfIdle();
    }

    private void TryCompleteIfIdle()
    {
        if (_seedingCompleted && Volatile.Read(ref _inFlight) == 0)
        {
            _holder.Channel.Writer.TryComplete();
        }
    }
}
