using System.Collections.Concurrent;

namespace LLM.HHData.Services;

public interface IEmployerVacancyIndex
{
    void Upsert(string employerId, string vacanciesUrl);
    bool TryGet(string employerId, out string? vacanciesUrl);
    IReadOnlyDictionary<string, string> Snapshot(); // пригодится следующему шагу
    void Flush();
}

public sealed class InMemoryEmployerVacancyIndex : IEmployerVacancyIndex
{
    private readonly ConcurrentDictionary<string, string> _map = new();

    public void Upsert(string employerId, string vacanciesUrl)
        => _map[employerId] = vacanciesUrl;

    public bool TryGet(string employerId, out string? vacanciesUrl)
    {
        var ok = _map.TryGetValue(employerId, out var v);
        vacanciesUrl = v;
        return ok;
    }

    public IReadOnlyDictionary<string, string> Snapshot() => _map;

    public void Flush()
    {
        _map.Clear();
    }
}