using LLM.HHData.Config;
using LLM.HHData.Services;
using Microsoft.Extensions.Options;

namespace LLM.HHData.Http;

public interface IHttpSenderFactory
{
    IHttpSender CreateForProxy(ProxyInfo? fixedProxy);
}

public sealed class HttpSenderFactory : IHttpSenderFactory
{
    private readonly ISystemLogService _log;
    private readonly IOptions<AppConfig> _cfg;
    private readonly IProxyProvider _provider;

    public HttpSenderFactory(ISystemLogService log, IOptions<AppConfig> cfg, IProxyProvider provider)
    {
        _log = log; _cfg = cfg; _provider = provider;
    }

    public IHttpSender CreateForProxy(ProxyInfo? fixedProxy)
        => new HttpSender(_log, _cfg, _provider, fixedProxy);
}