using System.Net;

namespace LLM.HHData.Http;

public static class CookieLoader
{
    public static CookieContainer BuildCookieContainer(string path, IEnumerable<string> domainHints)
    {
        var cc = new CookieContainer();
        if (!File.Exists(path)) return cc;

        foreach (var line in File.ReadAllLines(path))
        {
            var l = line.Trim();
            if (string.IsNullOrEmpty(l) || l.StartsWith("#")) continue;

            var parts = l.Split('\t');
            if (parts.Length >= 7)
            {
                // Netscape: domain, flag, path, secure, expiry, name, value
                var domain = parts[0].TrimStart('.');
                var cookiePath = parts[2];
                var name = parts[5];
                var value = parts[6];
                TryAdd(cc, new Cookie(name, value, cookiePath, domain));
                continue;
            }

            var eq = l.IndexOf('=');
            if (eq > 0)
            {
                var name = l[..eq].Trim();
                var value = l[(eq + 1)..].Trim();
                foreach (var d in domainHints)
                    TryAdd(cc, new Cookie(name, value, "/", d.TrimStart('.')));
            }
        }
        return cc;

        static void TryAdd(CookieContainer cc, Cookie c) { try { cc.Add(c); } catch { } }
    }

    public static string BuildRawHeader(string path)
    {
        if (!File.Exists(path)) return "";
        var pairs = new List<string>();
        foreach (var line in File.ReadAllLines(path))
        {
            var l = line.Trim();
            if (string.IsNullOrEmpty(l) || l.StartsWith("#")) continue;

            var parts = l.Split('\t');
            if (parts.Length >= 7) pairs.Add($"{parts[5]}={parts[6]}");
            else pairs.Add(l);
        }
        return string.Join("; ", pairs.Distinct());
    }

    public static int CountCookies(string path)
    {
        if (!File.Exists(path)) return 0;
        int n = 0;
        foreach (var line in File.ReadAllLines(path))
        {
            var l = line.Trim();
            if (string.IsNullOrEmpty(l) || l.StartsWith("#")) continue;
            n++;
        }
        return n;
    }
}