namespace LLM.HHData.Config;

public sealed class AppConfig
{
    public BaseUrlsConfig BaseUrls { get; init; } = new();
    public HttpConfig Http { get; init; } = new();
    public CookiesConfig Cookies { get; init; } = new();
    public RunConfig Run { get; init; } = new();
    public DatabaseConfig Database { get; init; } = new();
    
    public sealed class DbBatchConfig
    {
        public int VacancyMaxBatch { get; init; } = 200;
        public int EmployerMaxBatch { get; init; } = 200;
        public int TouchMaxBatch { get; init; } = 500;
        public int FlushIntervalMs { get; init; } = 800;
        public int MaxPendingItems { get; init; } = 20000;
        public int TouchDebounceMinutes { get; init; } = 15;
    }

    public sealed class DatabaseConfig
    {
        public string ConnectionString { get; init; } = "";
        public string Schema { get; init; } = "data_lake";
        public DbBatchConfig Batch { get; init; } = new();
    }

    public sealed class BaseUrlsConfig
    {
        public string RootSitemap { get; init; } = "https://hh.ru/sitemap/main.xml";
        public string ApiEmployers { get; init; } = "https://api.hh.ru/employers";
        public string ApiVacancies { get; init; } = "https://api.hh.ru/vacancies";
    }
    public sealed class HttpConfig
    {
        public string UserAgent { get; init; } = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36";
        public double RequestsPerSecond { get; init; } = 1.0;
        public int TimeoutSeconds { get; init; } = 30;
        public int MaxRetries { get; init; } = 3;
        public int RetryInitialDelayMs { get; init; } = 800;
        public bool UseProxy { get; init; } = false;
        public string ProxyFilePath { get; init; } = "./proxies.txt";
        public string? BearerToken { get; init; }   // ← новое поле

        public int GlobalRps { get; init; } = 0;
        public int PerProxyRps { get; init; } = 1;
    }
    public sealed class CookiesConfig
    {
        public bool Enabled { get; init; } = true;
        public string Mode { get; init; } = "raw-header";
        public string FilePath { get; init; } = "./cookies.txt";
        public string[] DomainHints { get; init; } = [".hh.ru", ".api.hh.ru"];
        public string ApplyTo { get; init; } = "all";
    }

    public sealed class RunConfig
    {
        public int MaxEmployerSitemaps { get; init; } = 0;
        public string Locale { get; init; } = "RU";
        public string Host { get; init; } = "hh.ru";
        public int DelayBetweenXmlSeconds { get; init; } = 30;
        public int DelayBetweenEmployersMs { get; init; } = 1000;
        public int DelayBetweenVacancyPagesMs { get; init; } = 300;
        public int VacanciesPerPage { get; init; } = 20;
        public int MaxVacancyItemsPerEmployer { get; init; } = 1;
        public int DelayBetweenVacancyDetailsMs { get; init; } = 300;
        public int MaxVacancyDetailsPerEmployer { get; init; } = 1; // 0 = без лимита
        public int VacancyFreshTtlHours { get; init; } = 24;

        public bool UseProxyAgents { get; init; } = true;
        public int MaxDegreeEmployers { get; init; } = 100;
        public int MaxDegreeVacancyDetailsPerEmployer { get; init; } = 1;
        public int ProxyHealthCheckMinutes { get; init; } = 10;

        public int ProxyStrikeThreshold { get; init; } = 3;      // сколько фейлов подряд до бана
        public int ProxyStrikeWindowSec { get; init; } = 120;    // окно (сек), в котором считаем подряд


        public bool FollowRelatedVacancies { get; init; } = true;
        public int MaxRelatedVacancyDetailsPerSeed { get; init; } = 50;
    }
}