﻿const btn = document.querySelector('.menu-btn');
const mm = document.getElementById('mobileMenu');
const ovl = document.getElementById('menuOverlay');

let savedScrollY = 0;

function openMenu() {
    if (!mm) return;
    savedScrollY = window.scrollY || document.documentElement.scrollTop || 0;

    // фиксируем body (важно для iOS Safari)
    document.body.style.position = 'fixed';
    document.body.style.top = `-${savedScrollY}px`;
    document.body.style.left = '0';
    document.body.style.right = '0';
    document.body.style.width = '100%';

    document.documentElement.classList.add('no-scroll');
    document.body.classList.add('no-scroll');

    mm.classList.add('open');
    ovl?.classList.add('open');

    btn?.setAttribute('aria-expanded', 'true');
    btn?.setAttribute('aria-label', 'Закрыть меню');

    // фокус на первом пункте
    const firstLink = mm.querySelector('a,button');
    if (firstLink) firstLink.focus();
}

function closeMenu() {
    if (!mm) return;

    mm.classList.remove('open');
    ovl?.classList.remove('open');

    document.documentElement.classList.remove('no-scroll');
    document.body.classList.remove('no-scroll');

    // возвращаем скролл и снимаем фиксацию
    document.body.style.position = '';
    document.body.style.top = '';
    document.body.style.left = '';
    document.body.style.right = '';
    document.body.style.width = '';

    window.scrollTo(0, savedScrollY);

    btn?.setAttribute('aria-expanded', 'false');
    btn?.setAttribute('aria-label', 'Открыть меню');
}

btn?.addEventListener('click', () => {
    const isOpen = mm.classList.contains('open');
    if (isOpen) closeMenu(); else openMenu();
});
ovl?.addEventListener('click', closeMenu);

// ESC закрывает меню
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && mm?.classList.contains('open')) closeMenu();
});

// при переходе по пункту — закрываем
mm?.querySelectorAll('a').forEach(a => a.addEventListener('click', closeMenu));

// если расширили окно > 880px — закрываем и снимаем блокировку
window.matchMedia('(min-width: 881px)').addEventListener('change', (e) => {
    if (e.matches) closeMenu();
});


// --- Mobile submenu accordion ---
document.querySelectorAll('.m-acc').forEach(btn => {
    btn.addEventListener('click', () => {
        const expanded = btn.getAttribute('aria-expanded') === 'true';
        btn.setAttribute('aria-expanded', String(!expanded));
        const sub = btn.nextElementSibling;
        if (sub && sub.classList.contains('m-sub')) {
            sub.style.display = expanded ? 'none' : 'block';
        }
    });
});
