using AiLogia.Web.Data;

namespace AiLogia.Web.Services;

public class RecommendationsModel
{
    public long TelegramUserId { get; set; }
    public List<RecommendationDto> Recommendations { get; set; } = new();
    public bool HasRecommendations => Recommendations != null && Recommendations.Count > 0;
}

public interface IRecommendationsService
{
    public Task<RecommendationsModel> GetRecommendations(long telegramUserId);
}

public class RecommendationsService : IRecommendationsService
{
    private readonly IRecommendationsRepository _repo;

    public RecommendationsService(IRecommendationsRepository repo)
    {
        _repo = repo;
    }

    public async Task<RecommendationsModel> GetRecommendations(long telegramUserId)
    {
        var dtos = await _repo.GetRecommendations(telegramUserId);

        return new RecommendationsModel { TelegramUserId = telegramUserId, Recommendations = dtos };
    }
}
