using System;
using AiLogia.Web.Data;

namespace AiLogia.Web.Services;

public class MeModel
{
    public long TelegramUserId { get; set; }
    public IReadOnlyCollection<TestResultDto>? TestsResults { get; set; }

    public bool HesTestResults => TestsResults != null && TestsResults.Count > 0;
}

public interface IMeService
{
    public Task<MeModel> Get(long telegramUserId);
}

public class MeService : IMeService
{
    private readonly ITestsRepository _testsRepo;

    public MeService(ITestsRepository testsRepo)
    {
        _testsRepo = testsRepo;
    }

    public async Task<MeModel> Get(long telegramUserId)
    {
        var results = await _testsRepo.GetResults(telegramUserId);

        return new MeModel { TelegramUserId = telegramUserId, TestsResults = results };
    }
}
