using System;
using System.Security.Claims;

namespace AiLogia.Web.Infrastructure;

public interface ICurrentUser
{
    bool IsAuthenticated { get; }
    string? Id { get; }
    string? Username { get; }
    string? FullName { get; }
    long? TelegramId { get; }
}

public sealed class CurrentUser : ICurrentUser
{
    private readonly IHttpContextAccessor _http;
    private ClaimsPrincipal? Principal => _http.HttpContext?.User;

    public CurrentUser(IHttpContextAccessor http) => _http = http;

    public bool IsAuthenticated => Principal?.Identity?.IsAuthenticated == true;
    public string? Id => Principal?.FindFirstValue(ClaimTypes.NameIdentifier);
    public string? Username => Principal?.FindFirstValue("tg_username");
    public string? FullName => Principal?.FindFirstValue("tg_fullname");
    public long? TelegramId
    {
        get
        {
            var v = Principal?.FindFirst("tg_id")?.Value;
            return long.TryParse(v, out var id) ? id : (long?)null;
        }
    }
}