using Npgsql;

namespace AiLogia.Web.Data;

public class RecommendationDto
{
    public string DbValue { get; set; } = string.Empty;
}

public interface IRecommendationsRepository
{
    public Task<List<RecommendationDto>> GetRecommendations(long telegramUserId);
}
public class RecommendationsRepository : IRecommendationsRepository
{
    private readonly string _connectionString;

    public RecommendationsRepository(IConfiguration config)
    {
        _connectionString = config["ConnectionStrings:BotDb"] ?? throw new ArgumentException();
    }

    public async Task<List<RecommendationDto>> GetRecommendations(long telegramUserId)
    {
        var recommendations = new List<RecommendationDto>();

        try
        {
            await using var conn = new NpgsqlConnection(_connectionString);
            await conn.OpenAsync();

            // for single

            var cmd = new NpgsqlCommand("select get_recommendations(@user_id)", conn);

            cmd.Parameters.AddWithValue("user_id", NpgsqlTypes.NpgsqlDbType.Bigint, telegramUserId);

            var text = ((await cmd.ExecuteScalarAsync()) as string) ?? String.Empty;

            if (!String.IsNullOrEmpty(text))
                recommendations.Add(new RecommendationDto { DbValue = text });
        }
        catch (Exception ex)
        {
        }
        
        return recommendations;
    }
}
