using System;
using Microsoft.AspNetCore.Mvc;

namespace AiLogia.Web.Controllers;

[Route("programs")]
public class ProgramsController : Controller
{// GET /programs
    [HttpGet("")]
    public IActionResult Index() => View();

    [HttpGet("{id:int}/{slug?}", Name = "program-details")]
    public IActionResult Details(int id, string? slug) => View(model: new { id, slug });

    [HttpGet("category/{categorySlug}")]
    public IActionResult Category(string categorySlug) => View(model: categorySlug);

    [HttpGet("search")]
    public IActionResult Search([FromQuery] string q) => View(model: q);

}