using Microsoft.AspNetCore.Mvc;
using AiLogia.Web.Services;
using System.Security.Claims;

namespace AiLogia.Web.Controllers;

[ApiController]
[Route("api/[controller]")]
public class AssistantController : ControllerBase
{
    private readonly IAssistantProxyClient _proxy;
    public AssistantController(IAssistantProxyClient proxy) => _proxy = proxy;

    [HttpPost("chat")]
    public async Task<ActionResult<ChatResponse>> Chat([FromBody] ChatRequest req, CancellationToken ct)
    {
        var userCtx = new
        {
            IsAuthenticated = User.Identity?.IsAuthenticated ?? false,
            UserId = User.FindFirstValue(ClaimTypes.NameIdentifier),
            Name = User.Identity?.Name,
            Locale = Request.Headers["Accept-Language"].ToString()
            // сюда позже добавим тариф/роль/скиллы из твоей БД
        };

        var forward = req with { user = userCtx };
        var data = await _proxy.ChatAsync(forward, ct);
        return Ok(data);
    }
}