using System.Threading.Tasks;
using AiLogia.Web.Infrastructure;
using AiLogia.Web.Services;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;

namespace AiLogia.Web.Controllers;

[Route("account")]
[Authorize]
public class AccountController : Controller
{
    private readonly ICurrentUser _user;
    private readonly IRecommendationsService _recommendationsService;
    private readonly IMeService _meService;
    private readonly ITestsService _testsService;

    public AccountController(
        ICurrentUser user,
        IRecommendationsService recommendations, IMeService meService, ITestsService testsService)
    {
        _user = user;
        _recommendationsService = recommendations;
        _meService = meService;
        _testsService = testsService;
    }

    [HttpGet("")]
    public IActionResult Index() => RedirectToAction(nameof(Overview));

    [HttpGet("overview")]
    public IActionResult Overview() => View();

    [HttpGet("profile")]
    public IActionResult Profile() => View();

    [HttpGet("me")]
    public async Task<IActionResult> Me()
    {
        var telegramUserId = _user.TelegramId;

        if (telegramUserId.HasValue)
        {
            var model = await _meService.Get(telegramUserId.Value);

            return View(model);
        }
        else
        {
            // not logged in
            throw new InvalidOperationException();
        }
    }


    [HttpGet("recommendations")]
    public async Task<IActionResult> Recommendations()
    {
        var telegramUserId = _user.TelegramId;

        if (telegramUserId.HasValue)
        {
            var model = await _recommendationsService.GetRecommendations(telegramUserId.Value);

            return View(model);
        }
        else
        {
            // not logged in
            throw new InvalidOperationException();
        }
    }

    [HttpGet("track")]
    public IActionResult Track() => View();

    [HttpGet("courses")]
    public IActionResult Courses() => View();

    [HttpGet("tasks")]
    public IActionResult Tasks() => View();

    [HttpGet("cv")]
    public IActionResult Cv() => View();

    [HttpGet("billing")]
    public IActionResult Billing() => View();
}
