import react from '@vitejs/plugin-react'
import { defineConfig } from 'vite'
import path from 'path'
import { fileURLToPath } from 'url'

const __filename = fileURLToPath(import.meta.url)
const __dirname = path.dirname(__filename)

export default defineConfig({
  plugins: [react()],
  base: '/assistant/',
  build: {
    outDir: path.resolve(__dirname, '../wwwroot/assistant'),
    emptyOutDir: true,
    cssCodeSplit: false, // один общий CSS
    rollupOptions: {
      input: path.resolve(__dirname, 'index.html'),
      output: {
        entryFileNames: 'assistant.js',
        // делаем предсказуемое имя для CSS
        assetFileNames: (assetInfo) => {
          if (assetInfo.name && assetInfo.name.endsWith('.css')) {
            return 'assistant.css'
          }
          return 'assets/[name][extname]'
        },
        chunkFileNames: 'chunks/[name].js',
      },
    },
  },
})
