using System.Text.RegularExpressions;

namespace AiLogia.Bot.Utils;

public class TelegramTextEscaper
{    // Предкомпилированный regex для экранирования MarkdownV2-символов
    private static readonly Regex SpecialChars = new(@"(?<!\\)([_*\[\]()~`>#+\-=|{}.!/])", RegexOptions.Compiled);

    public static string Escape(string input)
    {
        return SpecialChars.Replace(input, @"\$1");
    }
}
