using System.Collections.Concurrent;

namespace AiLogia.Bot.Services;

public interface IFeedbackStateService
{
    void Enable(long userId);
    void Disable(long userId);
    bool IsEnabled(long userId);
}

public class InMemoryFeedbackStateService : IFeedbackStateService
{
    private readonly ConcurrentDictionary<long, byte> _set = new();
    public void Enable(long userId) => _set[userId] = 1;
    public void Disable(long userId) => _set.TryRemove(userId, out _);
    public bool IsEnabled(long userId) => _set.ContainsKey(userId);
}