using System;

namespace AiLogia.Bot.Models;

public class TestModel
{
    public int Id { get; set; }
    public string Title { get; set; } = default!;
    public string? Description { get; set; }
    public string ResultFunctionName { get; set; } = default!;
    public string AccessMode { get; set; } = default!;
}


public class QuestionModel
{
    public int Id { get; set; }
    public string Text { get; set; } = default!;
    public List<AnswerOption> Answers { get; set; } = new();
}


public class AnswerOption
{
    public int Id { get; set; }
    public string Letter { get; set; } = default!;
    public string Text { get; set; } = default!;
    public int Score { get; set; }
}

public class TestResultModel
{
    public int TestId { get; set; }
    public string TestTitle { get; set; } = default!;
    public string ResultText { get; set; } = default!;
    public string? Interpretation { get; set; }
    public DateTime CompletedAt { get; set; }
    public string TestAccessMode { get; set; } = default!;
    public string BotUsername { get; set; } = default!;
}

//

public class TestShortModel
{
    public int Id { get; set; }
    public string Code { get; set; } = default!;
    public string Title { get; set; } = default!;
    public string? GroupTitle { get; set; }
    public string AccessMode { get; set; } = "public";
}

//

public class UserAccessModel
{
    public long UserId { get; set; }
    public string AudienceType { get; set; } = "b2c";
    public string AccessLevel { get; set; } = "free";
    public DateTime? SubscriptionExpiresAt { get; set; }
    public bool HasActivePaidSubscription =>
       AccessLevel == "paid" && SubscriptionExpiresAt is { } dt && dt > DateTime.UtcNow;
}


//

public class PromotedChannel
{
    public string Name { get; set; } = default!;
    public string Url { get; set; } = default!;
}