using AiLogia.Bot.Data;
using AiLogia.Bot.Diagnostics;
using AiLogia.Bot.Services;
using Telegram.Bot;
using Telegram.Bot.Types;
using Telegram.Bot.Types.Enums;

namespace AiLogia.Bot.Handlers;

public class StartCommandHandler(
    ITelegramBotClient bot,
    ISystemLogService log,
    IUserActionTracker tracker,
    ITestsRepository repo) : ICommandHandler
{
    public string Command => "/start";

    private readonly ITelegramBotClient _bot = bot;
    private readonly ISystemLogService _log = log;
    private readonly IUserActionTracker _tracker = tracker;
    private readonly ITestsRepository _repo = repo;

    public async Task HandleAsync(Message message)
    {
        await _tracker.TrackAsync("command:start", message);

        var text = message.Text ?? "";

        // Переход по ссылке вида /start test_42
        if (text.StartsWith("/start test_"))
        {
            var idText = text.Replace("/start test_", "");

            if (int.TryParse(idText, out var testId))
            {
                var callback = new CallbackQuery
                {
                    From = message.From!,
                    Id = Guid.NewGuid().ToString(),
                    Data = $"test:{testId}",
                    Message = message
                };

                var handler = new TestSelectedHandler(_bot, _log, _tracker, _repo);
                await handler.HandleAsync(callback);
                return;
            }
        }

        var msg = @"👋 Привет! Я бот, который подскажет, как сделать работу эффективнее и развить новые навыки с помощью ИИ.
        
👋 /start — узнать, чем бот может быть полезен  
📋 /tests — пройти аудит и узнать, какие сильные стороны можно приобрести с помощью инструментов ИИ  
🧠 /me — посмотреть результаты последнего тестирования  
💡 /recommendations — получить персональные рекомендации по саморазвитию  
🔑 /auth — авторизоваться на сайте AILogia.ru";
        
/*
                        var msg = @$"👋 Привет! Я — бот, который поможет Вам лучше узнать себя с помощью психологических тестов. Вот что я умею: 

                📋 /tests — вывести список тестов и начать прохождение
                🧠 /me — показать Ваши результаты по тестам, пройденным ранее
                🧹 /forget — забыть результаты всех Ваших тестов
                📌 /share — сформирует сообщение, с помощью которого Вы сможете поделиться ботом с друзьями
                💡 /start — показать это сообщение";
                */

        // 💡 Команда /feedback - если ты хочешь поделиться идеей как улучшить бота"

        // Стандартный старт
        await _bot.SendMessage(
            chatId: message.Chat.Id,
            text: msg,
            parseMode: ParseMode.Markdown
        );
    }
}
