using AiLogia.Bot.Diagnostics;
using Microsoft.Extensions.Configuration;
using Telegram.Bot;
using Telegram.Bot.Types;

namespace AiLogia.Bot.Handlers;

public class ShareCommandHandler(ITelegramBotClient bot, IConfiguration configuration, IUserActionTracker tracker) : ICommandHandler
{
    public string Command => "/share";

    private readonly ITelegramBotClient _bot = bot;
    private readonly string _botShareLink = configuration["BotTgShareLink"]!;
    private readonly IUserActionTracker _tracker = tracker;

    public async Task HandleAsync(Message message)
    {
        await _tracker.TrackAsync("command:share", message);

        var text =
            "💫 Я прошёл классный психологический тест в Telegram!\n" +
            "🧠 Бот показывает результат и объясняет, что он значит. Очень интересно! 👀 Попробуй: 👉 " + _botShareLink;

        await _bot.SendMessage(message.Chat.Id, text);
    }
}

