using System;
using AiLogia.Bot.Data;
using AiLogia.Bot.Diagnostics;
using AiLogia.Bot.Services;
using Microsoft.Extensions.Configuration;
using Telegram.Bot;
using Telegram.Bot.Types;

namespace AiLogia.Bot.Handlers;

public class RecomendationsCommandHandler : ICommandHandler
{
    public string Command => "/recommendations";

    private readonly IConfiguration _config;
    private readonly ITelegramBotClient _bot;
    private readonly ISystemLogService _log;
    private readonly IUserActionTracker _tracker;
    private readonly IRecommendationsRepository _repo;

    public RecomendationsCommandHandler(IConfiguration configuration, ITelegramBotClient bot, ISystemLogService log,
    IUserActionTracker tracker, IRecommendationsRepository repo)
    {
        _config = configuration;
        _bot = bot;
        _log = log;
        _tracker = tracker;
        _repo = repo;
    }

    public async Task HandleAsync(Message message)
    {
        await _tracker.TrackAsync("command:recommendations", message);

        var userId = message?.From?.Id;
        var chatId = message?.Chat?.Id;

        if (chatId.HasValue && userId.HasValue)
        {
            var recommendation = await _repo.GetRecommendations(userId.Value);

            if (recommendation.HasData)
            {
                await _bot.SendMessage(chatId, recommendation.DbValue);
            }
            else
            {
                var msg = "Для формирования рекомендаций необходимо пройти тест. Вы можете сделать это с помощью команды /tests.";

                await _bot.SendMessage(chatId, msg);
            }
        }
    }
}
