using AiLogia.Bot.Services;
using Telegram.Bot;
using Telegram.Bot.Types;
using Telegram.Bot.Types.Enums;

namespace AiLogia.Bot.Handlers;

public class FeedbackCommandHandler : ICommandHandler
{
    private readonly ITelegramBotClient _bot;
    private readonly IFeedbackStateService _state;

    public string Command => "/feedback";

    public FeedbackCommandHandler(ITelegramBotClient bot, IFeedbackStateService state)
    {
        _bot = bot;
        _state = state;
    }

    public async Task HandleAsync(Message msg)
    {
        if (msg.Text?.StartsWith(Command, StringComparison.OrdinalIgnoreCase) != true)
            return;

        _state.Enable(msg.From!.Id);

        await _bot.SendMessage(
            chatId: msg.Chat.Id,
            text:
                "Напишите сообщение с обратной связью (текст, фото, голос, файл — всё можно). " +
                "Я перешлю его авторам.\n\n" +
                "Чтобы отменить — отправьте /cancel",
            parseMode: ParseMode.Markdown);
    }
}