using AiLogia.Bot.Services;
using Telegram.Bot;
using Telegram.Bot.Types;

namespace AiLogia.Bot.Handlers;

public class CancelFeedbackCommandHandler : ICommandHandler
{
    private readonly ITelegramBotClient _bot;
    private readonly IFeedbackStateService _state;
    public string Command => "/cancel";

    public CancelFeedbackCommandHandler(ITelegramBotClient bot, IFeedbackStateService state)
    {
        _bot = bot;
        _state = state;
    }

    public async Task HandleAsync(Message msg)
    {
        if (msg.Text?.StartsWith(Command, StringComparison.OrdinalIgnoreCase) != true)
            return;

        if (_state.IsEnabled(msg.From!.Id))
        {
            _state.Disable(msg.From!.Id);
            await _bot.SendMessage(msg.Chat.Id, "Отменил режим обратной связи.");
        }
        else
        {
            await _bot.SendMessage(msg.Chat.Id, "Нечего отменять 🙂");
        }
    }
}