using AiLogia.Bot.Services;
using Microsoft.Extensions.Configuration;
using Telegram.Bot;
using Telegram.Bot.Types;
using Telegram.Bot.Types.ReplyMarkups;

namespace AiLogia.Bot.Handlers;

public sealed class AuthCommandHandler : ICommandHandler
{
    public string Command => "/auth";
    private readonly ITelegramBotClient _bot;
    private readonly IAuthClient _auth;
    private readonly string _siteBaseUrl;

    public AuthCommandHandler(ITelegramBotClient bot, IAuthClient auth, IConfiguration cfg)
    {
        _bot = bot; _auth = auth;
        _siteBaseUrl = cfg["SiteBaseUrl"]!;
    }

    public async Task HandleAsync(Message msg)
    {
        // if (msg.Text?.StartsWith(Command, StringComparison.OrdinalIgnoreCase) != true) return;

        var u = msg.From!;
        var full = $"{u.FirstName} {u.LastName}".Trim();
        var (token, exp) = await _auth.CreateMagicLinkAsync(u.Id, u.Username, full, ttlMinutes: 15);

        var link = $"{_siteBaseUrl}/auth/tg?token={token}";

        //  await _bot.SendMessage(msg.Chat.Id,
        //      $"🔐 Одноразовая ссылка для входа (действует до {exp:yyyy-MM-dd HH:mm UTC}):\n{link}",
        //       linkPreviewOptions: new LinkPreviewOptions { IsDisabled = true });

        // var text = "🔐 Одноразовая ссылка для авторизации на сайте AILogia.ru (действует ~15 минут).";


        var ahref = $"<a href=\"{link}\">{link}</a>";
        var text = $@"👇 Вот ссылка для авторизации на AILogia.ru:  

👉 {ahref}

💡 Совет: лучше использовать внешний браузер (Safari / Chrome).  
Внутренний браузер Телеграма забудет что ты авторизован как только закроешь его.";

        var kb = new InlineKeyboardMarkup(
            InlineKeyboardButton.WithUrl("Войти на сайт", link)
        );

        await _bot.SendMessage(
            chatId: msg.Chat.Id,
            text: text,
            parseMode: Telegram.Bot.Types.Enums.ParseMode.Html,
            linkPreviewOptions: new LinkPreviewOptions { IsDisabled = true }
        );
/*
        await _bot.SendMessage(
            chatId: msg.Chat.Id,
            text: text,
            replyMarkup: kb,
            linkPreviewOptions: new LinkPreviewOptions { IsDisabled = true }
        );

        await _bot.SendMessage(
           chatId: msg.Chat.Id,
           text: "🔐 Нажмите, чтобы войти: <a href=\"" + link + "\">Авторизоваться</a>",
           parseMode: Telegram.Bot.Types.Enums.ParseMode.Html,
           linkPreviewOptions: new LinkPreviewOptions { IsDisabled = true }
       );
*/
    }
}