using AiLogia.Auth;
using AiLogia.Auth.Data;
using AiLogia.Auth.Features.MagicLinks;
using AiLogia.Auth.Services;

var builder = WebApplication.CreateBuilder(args);

builder.Services.AddSingleton<AuthDb>();
builder.Services.AddSingleton(new SimpleRateLimiter(TimeSpan.FromSeconds(0)));

builder.Configuration
     .AddJsonFile("config.json", optional: true, reloadOnChange: true)
     .AddEnvironmentVariables();

builder.WebHost.ConfigureKestrel(options =>
{
    // настройки будут подхвачены из "Kestrel" раздела в config.json
    options.Configure(builder.Configuration.GetSection("Kestrel"));
});

builder.Services.Configure<AuthOptions>(builder.Configuration.GetSection("Auth"));

var app = builder.Build();

app.MapGet("/healthz", () => Results.Ok(new { ok = true }));

app.MapMagicLinks();

app.Run();
