namespace AiLogia.Auth.Features.MagicLinks;

public sealed record CreateMagicLinkRequest(
    long telegram_user_id,
    string? username,
    string? full_name,
    int? ttl_minutes
);

public sealed record CreateMagicLinkResponse(
    string token,
    DateTime expires_at_utc
);

public sealed record ValidateMagicLinkResponse(
    bool valid,
    string? reason,
    MagicUser? user,
    DateTime? expires_at_utc
);

public sealed record MagicUser(
    long id,
    long telegram_user_id,
    string? username,
    string? full_name
);

public sealed record ConsumeMagicLinkRequest(string token);
public sealed record ConsumeMagicLinkResponse(bool consumed);
